<?php
require_once dirname(__DIR__) . '/config/db.php';

try {
    // First, create a super_admin flag in the roles table if it doesn't exist
    $stmt = $pdo->query("SHOW COLUMNS FROM roles LIKE 'is_super_admin'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE roles ADD COLUMN is_super_admin BOOLEAN DEFAULT FALSE");
        echo "Added is_super_admin column to roles table\n";
    }

    // Create or update Super Admin role
    $stmt = $pdo->prepare("SELECT id FROM roles WHERE name = 'Super Admin'");
    $stmt->execute();
    $superAdminRole = $stmt->fetch();
    
    if (!$superAdminRole) {
        // Create Super Admin role
        $stmt = $pdo->prepare("INSERT INTO roles (name, description, is_super_admin) VALUES (?, ?, ?)");
        $stmt->execute(['Super Admin', 'System Super Administrator with full access and protected privileges', true]);
        $superAdminRoleId = $pdo->lastInsertId();
        echo "Created Super Admin role\n";
    } else {
        $superAdminRoleId = $superAdminRole['id'];
        // Update existing Super Admin role
        $stmt = $pdo->prepare("UPDATE roles SET is_super_admin = TRUE WHERE id = ?");
        $stmt->execute([$superAdminRoleId]);
        echo "Updated existing Super Admin role\n";
    }
    
    // Get all permissions
    $stmt = $pdo->query("SELECT id FROM permissions");
    $permissions = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    // Remove existing permissions for super admin role
    $stmt = $pdo->prepare("DELETE FROM role_permissions WHERE role_id = ?");
    $stmt->execute([$superAdminRoleId]);
    
    // Add all permissions to super admin role
    $stmt = $pdo->prepare("INSERT INTO role_permissions (role_id, permission_id) VALUES (?, ?)");
    foreach ($permissions as $permissionId) {
        $stmt->execute([$superAdminRoleId, $permissionId]);
    }
    
    // Assign Super Admin role to the first user
    $stmt = $pdo->query("SELECT id FROM users ORDER BY id LIMIT 1");
    $user = $stmt->fetch();
    
    if ($user) {
        $stmt = $pdo->prepare("UPDATE users SET role_id = ? WHERE id = ?");
        $stmt->execute([$superAdminRoleId, $user['id']]);
        echo "Successfully assigned Super Admin role to user ID: " . $user['id'] . "\n";
    }

    // Add protection trigger to prevent modification of super admin role
    $pdo->exec("
        CREATE TRIGGER IF NOT EXISTS protect_super_admin_role
        BEFORE UPDATE ON roles
        FOR EACH ROW
        BEGIN
            IF OLD.is_super_admin = TRUE THEN
                SIGNAL SQLSTATE '45000'
                SET MESSAGE_TEXT = 'Cannot modify Super Admin role';
            END IF;
        END;
    ");

    // Add protection trigger to prevent deletion of super admin role
    $pdo->exec("
        CREATE TRIGGER IF NOT EXISTS prevent_super_admin_deletion
        BEFORE DELETE ON roles
        FOR EACH ROW
        BEGIN
            IF OLD.is_super_admin = TRUE THEN
                SIGNAL SQLSTATE '45000'
                SET MESSAGE_TEXT = 'Cannot delete Super Admin role';
            END IF;
        END;
    ");

    echo "Successfully set up Super Admin role with protection\n";
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
} 